using System;
using System.Xml;

using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary.Messages
{
	/// <summary>
	/// This class represents all VistALink protocol 
	/// security response messages.
	/// </summary>
	public abstract class SecurityBaseResponseMessage : BaseResponseMessage
	{
		/// <summary>
		/// VistALink message type string. 
		/// This constant is made public to recognize message XML.
		/// </summary>
		public const string MessageType = "gov.va.med.foundations.security.response";

		/// <summary>
		/// Contstructor specifying minimal required VistALink security response message parameters. 
		/// </summary>
		/// <param name="sourceXSD">VistALink message XSD schema file name.</param>
		/// <param name="responseType">VistALink message response type.</param>
		/// <param name="responseStatus">Response status. Normally will indicate status of preceding request. </param>
		protected SecurityBaseResponseMessage( string sourceXSD, string responseType, ResponseStatus responseStatus ) 
			: base( MessageType, sourceXSD, responseType, responseStatus ) {}

		/// <summary>
		/// Constructor extending standard VistALink message deserialization constructor. 
		/// Allows recreating message object from XML document.
		/// </summary>
		/// <param name="sourceXSD">VistALink message XSD schema file name.</param>
		/// <param name="responseType">VistALink message response type.</param>
		/// <param name="sourceDoc">Source XML document.</param>
		protected SecurityBaseResponseMessage( string sourceXSD, string responseType, XmlDocument sourceDoc ) 
			: base( MessageType, sourceXSD, responseType, sourceDoc ) 
		{
			SecurityMessageImplementationMixin.ParseCommonSecurityXmlContent( sourceDoc );
		}

		/// <summary>
		/// Standard VistALink message XML serialization method, 
		/// translating message object into XML representation.
		/// </summary>
		/// <param name="writer">XmlWriter object to use for serialization.</param>
		protected override void WriteXmlMessageBody( XmlWriter writer )
		{
			SecurityMessageImplementationMixin.WriteCommonSecurityXmlContent( writer );
			base.WriteXmlMessageBody( writer );
		}
	}
}
